;*****************************************************************
;* IDE Boot Cart.asm
;*****************************************************************
;* Loads the MICRO-INNOVATIONS boot EPROM from a game cart
;* and launches it from intrinsic RAM.
;*****************************************************************
; define standard assembler directives to work with TASM
#define	org	.org
#define	end	.end
#define	byte	.byte
#define	word	.word

#define	DCB		.byte
#define	dcb		.byte

#define DCW		.word
#define dcw		.word

;*****************************************************************
;* test cart header
;*****************************************************************
	org	$8000	; start of cart memory
	
	DCB	$55,$AA	; test cart ID
	DCB	00,00,00,00,00,00,00,00	; filler, we don't use this
;	org	800AH		; location of cart start address
	DCW	CARTSTART	; cart start address, used to execute cart code
;*****************************************************************

;*****************************************************************
;* the first code executed in the cart	
;* Steps match the post where I listed them on Atariage.
;*****************************************************************
CARTSTART:

; Step 1, copy from cart to OS7/24k intrinsic RAM
	di			; interrupts would be bad durring this process

	; copy code from cart into 24K intrinsic RAM
	ld	hl,LOWRAMCODE			; start
	ld	de,$2000				; destination... start of RAM
	ld	bc,ENDCODE - LOWRAMCODE	; length
	ldir
	jp	$2000					; call code in 24K intrinsic RAM

; code from here on to be copied	
LOWRAMCODE:
; Step 2, copy from OS7/24K intrinsic RAM bank to high intrinsic RAM bank
	org	$2000		; start of 24K Intrinsic RAM
	
	ld	a,$09
	out	($03),a	; Select intrinsic RAM in upper bank and OS7/24K intrinsic RAM in lower bank

	; copy startup code from lower RAM into intrinsic RAM
	ld	hl,BOOTCODE		; start
	ld	de,$8000		; destination
	ld	bc,ENDCODE - BOOTCODE	; length
	ldir
	
	ld	a,$01		; to patch ROM to use intrinsic RAM upper and lower 
	ld	($8004),a	; patch 05h to 01h
	
	jp	$8002			; call boot ROM code in high RAM

BOOTCODE:
;data we want to load goes here
	dcb		$66,$99,$F3,$3E,$05,$D3,$7F,$21,$ED,$45,$22,$66,$00,$21,$1B,$80
	dcb		$11,$00,$01,$01,$7B,$06,$ED,$B0,$C3,$00,$01,$3E,$01,$D3,$7F,$21
	dcb		$12,$01,$11,$00,$80,$01,$69,$06,$ED,$B0,$C3,$00,$80,$ED,$4B,$43
	dcb		$84,$ED,$41,$ED,$4B,$3F,$84,$ED,$41,$21,$00,$60,$11,$00,$E0,$01
	dcb		$C0,$1E,$ED,$B0,$ED,$4B,$41,$84,$ED,$41,$ED,$4B,$45,$84,$ED,$41
	dcb		$31,$58,$FE,$21,$60,$FD,$11,$61,$FD,$01,$47,$01,$36,$00,$ED,$B0
	dcb		$3E,$05,$32,$60,$FD,$3E,$01,$32,$6E,$FD,$CD,$11,$FD,$CD,$53,$FD
	dcb		$AF,$21,$00,$00,$11,$00,$40,$CD,$26,$FD,$CD,$BD,$81,$CD,$5D,$FC
	dcb		$11,$00,$D4,$21,$90,$D3,$CD,$BA,$FC,$CD,$87,$81,$3E,$C3,$32,$7B
	dcb		$F1,$21,$33,$E4,$22,$7C,$F1,$32,$E6,$F1,$21,$8A,$E4,$22,$E7,$F1
	dcb		$32,$25,$F3,$21,$6B,$E5,$22,$26,$F3,$32,$46,$F4,$21,$86,$E5,$22
	dcb		$47,$F4,$32,$73,$F4,$21,$AD,$E5,$22,$74,$F4,$32,$4C,$E8,$21,$D8
	dcb		$E5,$22,$4D,$E8,$32,$E2,$F4,$21,$AB,$E3,$22,$E3,$F4,$DD,$21,$56
	dcb		$FD,$3E,$C9,$DD,$77,$00,$DD,$77,$03,$DD,$77,$06,$DD,$77,$FA,$01
	dcb		$24,$00,$21,$47,$84,$11,$AB,$E3,$ED,$B0,$01,$FE,$01,$21,$6B,$84
	dcb		$11,$E7,$E3,$ED,$B0,$3E,$04,$CD,$70,$81,$30,$13,$3E,$05,$CD,$70
	dcb		$81,$30,$0C,$3E,$08,$CD,$70,$81,$30,$05,$3E,$18,$32,$6F,$FD,$AF
	dcb		$32,$E7,$E3,$3E,$18,$01,$00,$00,$11,$00,$00,$21,$00,$C8,$CD,$7B
	dcb		$F1,$3A,$09,$C8,$32,$F0,$E4,$3A,$06,$C8,$32,$1B,$E5,$32,$2D,$81
	dcb		$3A,$07,$C8,$32,$0C,$E5,$2A,$03,$C8,$22,$4C,$E5,$22,$24,$81,$3A
	dcb		$05,$C8,$32,$31,$81,$21,$14,$C8,$11,$E8,$E3,$01,$0A,$00,$ED,$B0
	dcb		$11,$67,$02,$7B,$D3,$04,$7A,$D3,$05,$3E,$11,$D3,$02,$3E,$03,$F6
	dcb		$A0,$D3,$06,$3E,$91,$D3,$07,$CD,$3E,$E5,$DB,$07,$47,$E6,$01,$3A
	dcb		$6F,$FD,$47,$FE,$18,$C2,$C8,$F8,$2A,$01,$C8,$11,$13,$00,$ED,$52
	dcb		$7E,$E6,$0F,$78,$CA,$00,$C8,$01,$00,$00,$2A,$2B,$C8,$11,$0D,$00
	dcb		$B7,$ED,$52,$EB,$21,$00,$C8,$CD,$7B,$F1,$C3,$00,$C8,$32,$6F,$FD
	dcb		$CD,$7E,$FC,$37,$C0,$3A,$6F,$FD,$CD,$54,$FC,$FD,$7E,$14,$E6,$0F
	dcb		$FE,$03,$3F,$C9,$3E,$55,$D3,$04,$3E,$AA,$D3,$03,$DB,$04,$FE,$55
	dcb		$C2,$30,$FC,$DB,$03,$FE,$AA,$C2,$30,$FC,$3E,$04,$D3,$5A,$00,$00
	dcb		$AF,$D3,$5A,$CD,$B4,$81,$3E,$02,$D3,$5A,$CD,$B4,$81,$3E,$10,$D3
	dcb		$07,$DB,$07,$EE,$50,$E6,$D2,$20,$F8,$C9,$3E,$03,$D3,$7F,$3A,$62
	dcb		$FD,$CB,$AF,$4F,$06,$01,$CD,$20,$FD,$21,$00,$00,$11,$FF,$3F,$AF
	dcb		$CD,$26,$FD,$CD,$85,$1F,$CD,$7F,$1F,$DD,$21,$27,$83,$CD,$08,$82
	dcb		$DD,$21,$50,$82,$CD,$08,$82,$21,$6A,$82,$11,$04,$02,$46,$23,$4E
	dcb		$23,$CD,$0B,$08,$21,$E4,$82,$CD,$3A,$82,$01,$C0,$01,$CD,$20,$FD
	dcb		$3E,$01,$D3,$7F,$C9,$DD,$66,$01,$DD,$6E,$00,$DD,$56,$03,$DD,$5E
	dcb		$02,$DD,$46,$05,$DD,$4E,$04,$C5,$E5,$D5,$0C,$0D,$28,$05,$06,$00
	dcb		$CD,$1A,$FD,$D1,$E1,$C1,$04,$05,$C8,$C5,$06,$00,$09,$EB,$09,$EB
	dcb		$C1,$0E,$00,$CD,$1A,$FD,$C9,$7E,$3C,$C8,$56,$23,$5E,$23,$4E,$23
	dcb		$E5,$06,$00,$09,$E3,$06,$01,$CD,$0B,$08,$E1,$18,$EA,$56,$82,$00
	dcb		$20,$14,$00,$50,$50,$50,$50,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$50
	dcb		$50,$50,$50,$50,$50,$50,$50,$05,$18,$00,$61,$63,$63,$64,$00,$61
	dcb		$63,$63,$63,$6E,$00,$61,$63,$63,$64,$00,$61,$63,$64,$00,$7A,$63
	dcb		$7B,$00,$62,$60,$66,$65,$00,$62,$60,$6F,$70,$60,$00,$62,$60,$66
	dcb		$65,$00,$62,$60,$65,$00,$6A,$60,$00,$00,$69,$67,$68,$60,$7C,$00
	dcb		$60,$71,$72,$60,$00,$69,$67,$68,$60,$7C,$00,$60,$60,$79,$60,$60
	dcb		$00,$00,$6A,$60,$60,$60,$65,$00,$60,$73,$74,$60,$00,$6A,$60,$60
	dcb		$60,$65,$00,$60,$75,$60,$77,$60,$00,$69,$60,$6B,$6C,$6D,$60,$7C
	dcb		$60,$60,$60,$7D,$69,$60,$6B,$6C,$6D,$60,$7C,$60,$76,$60,$78,$60
	dcb		$00,$09,$07,$11,$48,$41,$52,$44,$20,$44,$52,$49,$56,$45,$20,$53
	dcb		$59,$53,$54,$45,$4D,$0C,$06,$14,$42,$59,$20,$4D,$49,$43,$52,$4F
	dcb		$2D,$49,$4E,$4E,$4F,$56,$41,$54,$49,$4F,$4E,$53,$10,$0E,$05,$5E
	dcb		$31,$39,$39,$31,$12,$0A,$0C,$41,$4A,$4D,$20,$53,$4F,$46,$54,$57
	dcb		$41,$52,$45,$FF,$2D,$83,$E0,$02,$10,$01,$00,$FA,$23,$22,$00,$00
	dcb		$00,$00,$00,$20,$60,$A0,$00,$00,$00,$00,$7C,$82,$BA,$A2,$BA,$82
	dcb		$7C,$00,$3C,$42,$B9,$A5,$B9,$AD,$42,$3C,$FF,$FF,$FF,$FF,$FF,$FF
	dcb		$FF,$FF,$00,$00,$00,$00,$0F,$0F,$1F,$1F,$3F,$3F,$7F,$7F,$01,$00
	dcb		$00,$00,$00,$00,$00,$00,$FF,$FF,$FF,$FF,$00,$00,$00,$00,$C0,$C0
	dcb		$E0,$E0,$F0,$F0,$F8,$F8,$FC,$FC,$FE,$FE,$FF,$FF,$FF,$FF,$CF,$CF
	dcb		$87,$87,$FF,$FF,$FF,$FF,$FE,$FE,$FC,$FC,$87,$03,$03,$03,$01,$01
	dcb		$00,$00,$00,$00,$01,$01,$03,$03,$07,$07,$0F,$0F,$1F,$1F,$3F,$3F
	dcb		$7F,$7F,$FF,$FF,$C0,$C0,$80,$80,$00,$00,$FF,$FF,$00,$00,$00,$00
	dcb		$00,$00,$FF,$FF,$03,$03,$01,$01,$00,$00,$00,$00,$00,$00,$F0,$FC
	dcb		$FE,$FE,$FF,$FF,$FF,$FF,$FF,$80,$80,$80,$FF,$FF,$FF,$FF,$FF,$03
	dcb		$01,$01,$80,$80,$80,$80,$80,$80,$80,$80,$01,$01,$01,$01,$01,$01
	dcb		$01,$01,$80,$80,$80,$80,$80,$80,$80,$FF,$01,$01,$01,$01,$01,$01
	dcb		$03,$FF,$7F,$7F,$3F,$3F,$1F,$1F,$0F,$0F,$07,$07,$03,$03,$01,$01
	dcb		$00,$00,$FE,$FE,$FC,$FC,$F8,$F8,$F0,$F0,$E0,$E0,$C0,$C0,$80,$80
	dcb		$00,$00,$00,$00,$81,$81,$C3,$C3,$E7,$E7,$00,$00,$00,$00,$03,$03
	dcb		$07,$07,$F3,$55,$51,$51,$00,$00,$00,$00,$00,$00,$80,$80,$C0,$C0
	dcb		$E0,$E0,$FF,$FF,$FF,$FF,$FE,$FE,$FC,$F0,$00,$00,$3F,$02,$3F,$00
	dcb		$7F,$00,$7F,$01,$CD,$A5,$FB,$F5,$3A,$75,$FD,$FE,$99,$28,$09,$FE
	dcb		$98,$CA,$47,$E5,$F1,$C3,$E5,$F4,$AF,$32,$E7,$E3,$47,$4F,$57,$5F
	dcb		$3E,$18,$21,$00,$C8,$C3,$60,$E5,$00,$00,$00,$00,$00,$00,$00,$00
	dcb		$00,$00,$00,$CD,$60,$2F,$3A,$B5,$41,$D6,$05,$06,$35,$38,$0B,$06
	dcb		$36,$28,$07,$D6,$13,$06,$31,$38,$01,$04,$78,$F5,$CD,$DA,$2E,$F1
	dcb		$FE,$32,$20,$08,$3A,$E7,$E3,$C6,$30,$CD,$DA,$2E,$3E,$3E,$C3,$DA
	dcb		$2E,$CD,$00,$2E,$28,$08,$CD,$6D,$2E,$D0,$D6,$26,$6F,$13,$7D,$32
	dcb		$E7,$E3,$37,$C9,$C5,$D5,$E5,$FE,$18,$C2,$7E,$F1,$CD,$EB,$E4,$3E
	dcb		$0A,$32,$54,$E4,$CD,$01,$E5,$3E,$20,$D3,$07,$CD,$3E,$E5,$DB,$07
	dcb		$E6,$01,$28,$0D,$3E,$00,$3D,$32,$54,$E4,$20,$E8,$3E,$81,$B7,$18
	dcb		$25,$E1,$E5,$01,$59,$00,$0D,$ED,$78,$77,$23,$0C,$ED,$A2,$20,$F6
	dcb		$CD,$3E,$E5,$DB,$07,$E6,$08,$28,$FA,$0D,$ED,$78,$77,$23,$0C,$ED
	dcb		$A2,$20,$F6,$AF,$3E,$80,$37,$E1,$D1,$C1,$C9,$C5,$FD,$E5,$FE,$18
	dcb		$C2,$E9,$F1,$D5,$E5,$CD,$EB,$E4,$3E,$0A,$32,$54,$E4,$CD,$01,$E5
	dcb		$3E,$30,$D3,$07,$CD,$3E,$E5,$DB,$07,$E6,$01,$28,$0E,$3A,$54,$E4
	dcb		$3D,$32,$54,$E4,$20,$E7,$3E,$81,$B7,$18,$2A,$E1,$E5,$23,$01,$58
	dcb		$00,$0C,$7E,$ED,$79,$2B,$0D,$ED,$A3,$23,$23,$20,$F4,$CD,$3E,$E5
	dcb		$DB,$07,$E6,$08,$28,$FA,$0C,$7E,$ED,$79,$2B,$0D,$ED,$A3,$23,$23
	dcb		$20,$F4,$AF,$3E,$80,$37,$E1,$D1,$FD,$E1,$C1,$C9,$21,$E7,$E3,$7E
	dcb		$FE,$01,$38,$02,$AF,$77,$23,$4F,$06,$00,$09,$66,$68,$19,$22,$06
	dcb		$E5,$C9,$CD,$3E,$E5,$AF,$21,$00,$00,$29,$CE,$01,$01,$44,$00,$11
	dcb		$FF,$FF,$ED,$42,$13,$30,$FB,$3D,$20,$F8,$09,$01,$11,$00,$AF,$3D
	dcb		$ED,$42,$3C,$30,$FB,$ED,$4A,$47,$7D,$D3,$03,$7B,$D3,$04,$7A,$D3
	dcb		$05,$3E,$02,$D3,$02,$78,$F6,$A0,$D3,$06,$C9,$3E,$70,$D3,$07,$DB
	dcb		$07,$EE,$50,$E6,$D2,$20,$F8,$C9,$F1,$E5,$D5,$C5,$11,$66,$02,$06
	dcb		$00,$CD,$2A,$E5,$CD,$3A,$E5,$AF,$32,$75,$FD,$C1,$D1,$E1,$C3,$ED
	dcb		$F4,$31,$58,$FE,$CD,$7B,$F1,$06,$18,$C3,$00,$C8,$FE,$08,$11,$A0
	dcb		$00,$38,$0A,$11,$FF,$00,$FE,$18,$20,$03,$FD,$E1,$C9,$C5,$D5,$E5
	dcb		$C3,$28,$F3,$00,$00,$00,$00,$C5,$D5,$4F,$F6,$10,$FE,$18,$79,$C2
	dcb		$49,$F4,$11,$9A,$E5,$D5,$C5,$D5,$C3,$49,$F4,$F5,$FD,$CB,$00,$7E
	dcb		$28,$FA,$FD,$7E,$14,$E6,$0F,$FD,$77,$14,$F1,$D1,$C1,$C9,$CD,$46
	dcb		$F4,$F5,$FE,$07,$30,$04,$F1,$C3,$76,$F4,$FD,$36,$00,$01,$FD,$CB
	dcb		$00,$7E,$28,$FA,$FD,$7E,$14,$E6,$0F,$FD,$77,$14,$F1,$FE,$18,$20
	dcb		$05,$3E,$80,$FD,$77,$00,$C3,$82,$F4,$E5,$FD,$E1,$FD,$CB,$0C,$7E
	dcb		$C2,$3C,$E8,$C3,$4F,$E8,$00
ENDCODE:
	end
	